/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.EventDispatcher;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Painter;
import com.sun.lwuit.StaticAnimation;
import com.sun.lwuit.animations.Animation;
import com.sun.lwuit.animations.Motion;
import com.sun.lwuit.events.FocusListener;
import com.sun.lwuit.events.StyleListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import java.util.Hashtable;

public class Component
implements Animation,
StyleListener {
    private Component nextFocusDown;
    private Component nextFocusUp;
    private boolean enabled = true;
    private Component nextFocusRight;
    private Component nextFocusLeft;
    public static final int BRB_CONSTANT_ASCENT = 1;
    public static final int BRB_CONSTANT_DESCENT = 2;
    public static final int BRB_CENTER_OFFSET = 3;
    public static final int BRB_OTHER = 4;
    private boolean visible = true;
    private boolean cellRenderer;
    private boolean fixedPosition;
    private Rectangle bounds = new Rectangle(0, 0, new Dimension(0, 0));
    private int scrollX;
    private int scrollY;
    private Dimension preferredSize;
    private Style style;
    private Container parent;
    private boolean focused = false;
    private boolean focusPainted = true;
    private EventDispatcher focusListeners = new EventDispatcher();
    private boolean handlesInput = false;
    private boolean shouldCalcPreferredSize = true;
    private boolean focusable = true;
    private boolean isScrollVisible = true;
    private boolean smoothScrolling;
    private int animationSpeed;
    private Motion animationMotion;
    private Motion draggedMotion;
    private boolean dragActivated;
    private int initialScrollY = -1;
    private int destScrollY = -1;
    private int lastScrollY;
    private int beforeLastScrollY;
    private long[] lastTime = new long[2];
    private int[] lastDragged = new int[2];
    private int pLastDragged = 0;
    private boolean initialized;
    public static final int CENTER = 4;
    public static final int TOP = 0;
    public static final int LEFT = 1;
    public static final int BOTTOM = 2;
    public static final int RIGHT = 3;
    private Hashtable clientProperties;
    private Rectangle dirtyRegion = null;
    private Object dirtyRegionLock = new Object();
    private boolean sizeRequestedByUser = false;

    protected Component() {
        this.style = UIManager.getInstance().getComponentStyle(this.getUIID());
        if (this.style != null) {
            this.style.addStyleListener(this);
            this.style.setBgPainter(new BGPainter());
        }
        LookAndFeel laf = UIManager.getInstance().getLookAndFeel();
        this.animationSpeed = laf.getDefaultSmoothScrollingSpeed();
    }

    public int getX() {
        return this.bounds.getX();
    }

    public int getY() {
        return this.bounds.getY();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Object getClientProperty(String key) {
        if (this.clientProperties == null) {
            return null;
        }
        return this.clientProperties.get(key);
    }

    public void putClientProperty(String key, Object value) {
        if (this.clientProperties == null) {
            if (value == null) {
                return;
            }
            this.clientProperties = new Hashtable();
        }
        if (value == null) {
            this.clientProperties.remove(key);
            if (this.clientProperties.size() == 0) {
                this.clientProperties = null;
            }
        } else {
            this.clientProperties.put(key, value);
        }
    }

    public final Rectangle getDirtyRegion() {
        return this.dirtyRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDirtyRegion(Rectangle dirty) {
        Object object = this.dirtyRegionLock;
        synchronized (object) {
            this.dirtyRegion = dirty;
        }
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public int getWidth() {
        return this.bounds.getSize().getWidth();
    }

    public int getHeight() {
        return this.bounds.getSize().getHeight();
    }

    public void setX(int x) {
        this.bounds.setX(x);
    }

    public void setY(int y) {
        this.bounds.setY(y);
    }

    public int getBaseline(int width, int height) {
        return height - this.getStyle().getPadding(2);
    }

    public int getBaselineResizeBehavior() {
        return 4;
    }

    public void setPreferredSize(Dimension d) {
        this.preferredSize().setWidth(d.getWidth());
        this.preferredSize().setHeight(d.getHeight());
        this.sizeRequestedByUser = true;
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    public void setPreferredW(int preferredW) {
        this.setPreferredSize(new Dimension(preferredW, this.getPreferredH()));
    }

    public void setPreferredH(int preferredH) {
        this.setPreferredSize(new Dimension(this.getPreferredW(), preferredH));
    }

    public int getPreferredW() {
        return this.getPreferredSize().getWidth();
    }

    public int getPreferredH() {
        return this.getPreferredSize().getHeight();
    }

    public void setWidth(int width) {
        this.bounds.getSize().setWidth(width);
    }

    public void setHeight(int height) {
        this.bounds.getSize().setHeight(height);
    }

    public void setSize(Dimension d) {
        Dimension d2 = this.bounds.getSize();
        d2.setWidth(d.getWidth());
        d2.setHeight(d.getHeight());
    }

    protected String getUIID() {
        return null;
    }

    public Container getParent() {
        return this.parent;
    }

    void setParent(Container parent) {
        this.parent = parent;
    }

    public void addFocusListener(FocusListener l) {
        this.focusListeners.addListener(l);
    }

    public void removeFocusListener(FocusListener l) {
        this.focusListeners.removeListener(l);
    }

    protected void fireClicked() {
    }

    protected boolean isSelectableInteraction() {
        return false;
    }

    void fireFocusGained() {
        this.fireFocusGained(this);
    }

    void fireFocusLost() {
        this.fireFocusLost(this);
    }

    void fireFocusGained(Component cmp) {
        Form f;
        if (cmp.isCellRenderer()) {
            return;
        }
        this.focusListeners.fireFocus(cmp);
        this.focusGainedInternal();
        if (this.isSelectableInteraction() && (f = this.getComponentForm()) != null) {
            f.addSelectCommand();
        }
    }

    void fireFocusLost(Component cmp) {
        Form f;
        if (cmp.isCellRenderer()) {
            return;
        }
        if (this.isSelectableInteraction() && (f = this.getComponentForm()) != null) {
            f.removeSelectCommand();
        }
        this.focusListeners.fireFocus(cmp);
        this.focusLostInternal();
    }

    void fireActionEvent() {
    }

    void focusGainedInternal() {
    }

    void focusLostInternal() {
    }

    public void paintBackgrounds(Graphics g) {
        Rectangle bounds = new Rectangle(this.getAbsoluteX(), this.getAbsoluteY(), this.getWidth(), this.getHeight());
        this.drawPainters(g, this.getParent(), this, bounds);
    }

    public int getAbsoluteX() {
        int x = this.getX() - this.getScrollX();
        Container parent = this.getParent();
        if (parent != null) {
            x += parent.getAbsoluteX();
        }
        return x;
    }

    public int getAbsoluteY() {
        int y = this.getY() - this.getScrollY();
        Container parent = this.getParent();
        if (parent != null) {
            y += parent.getAbsoluteY();
        }
        return y;
    }

    final void paintInternal(Graphics g) {
        this.paintInternal(g, true);
    }

    final void paintInternal(Graphics g, boolean paintIntersects) {
        int oHeight;
        int oWidth;
        int oY;
        if (!this.isVisible()) {
            return;
        }
        int oX = g.getClipX();
        if (this.bounds.intersects(oX, oY = g.getClipY(), oWidth = g.getClipWidth(), oHeight = g.getClipHeight())) {
            g.clipRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            this.paintBackground(g);
            if (this.isScrollable()) {
                int scrollX = this.getScrollX();
                int scrollY = this.getScrollY();
                g.translate(-scrollX, -scrollY);
                this.paint(g);
                g.translate(scrollX, scrollY);
                if (this.isScrollVisible) {
                    this.paintScrollbars(g);
                }
            } else {
                this.paint(g);
            }
            if (this.isBorderPainted()) {
                this.paintBorder(g);
            }
            if (paintIntersects && this.parent != null) {
                this.paintIntersectingComponentsAbove(g);
            }
            g.setClip(oX, oY, oWidth, oHeight);
        }
    }

    private void paintIntersectingComponentsAbove(Graphics g) {
        Component component = this;
        Rectangle bounds = new Rectangle(this.getAbsoluteX(), this.getAbsoluteY(), this.getWidth(), this.getHeight());
        int tx = g.getTranslateX();
        int ty = g.getTranslateY();
        g.translate(-tx, -ty);
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            g.translate(parent.getAbsoluteX() + parent.getScrollX(), parent.getAbsoluteY() + parent.getScrollY());
            parent.paintIntersecting(g, component, bounds, true);
            g.translate(-parent.getAbsoluteX() - parent.getScrollX(), -parent.getAbsoluteY() - parent.getScrollY());
            component = parent;
        }
        g.translate(tx, ty);
    }

    protected void paintScrollbars(Graphics g) {
        if (this.isScrollableX()) {
            this.paintScrollbarX(g);
        }
        if (this.isScrollableY()) {
            this.paintScrollbarY(g);
        }
    }

    protected void paintScrollbarX(Graphics g) {
        float offset = (float)this.getScrollX() / (float)this.getPreferredW();
        float block = (float)this.getWidth() / (float)this.getPreferredW();
        UIManager.getInstance().getLookAndFeel().drawHorizontalScroll(g, this, offset, block);
    }

    protected void paintScrollbarY(Graphics g) {
        float offset = (float)this.getScrollY() / (float)this.getPreferredH();
        float block = (float)this.getHeight() / (float)this.getPreferredH();
        UIManager.getInstance().getLookAndFeel().drawVerticalScroll(g, this, offset, block);
    }

    public final void paintComponent(Graphics g) {
        this.paintComponent(g, true);
    }

    public final void paintComponent(Graphics g, boolean background) {
        Painter glass;
        int clipX = g.getClipX();
        int clipY = g.getClipX();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        int translateX = 0;
        int translateY = 0;
        if (!this.isFixedPosition()) {
            for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
                translateX += parent.getX();
                translateY += parent.getY();
                if (parent.isScrollableX()) {
                    translateX -= parent.getScrollX();
                }
                if (parent.isScrollableY()) {
                    translateY -= parent.getScrollY();
                }
                g.clipRect(parent.getAbsoluteX() + parent.getScrollX(), parent.getAbsoluteY() + parent.getScrollY(), parent.getWidth(), parent.getHeight());
                if (!parent.isFixedPosition()) continue;
                translateX = parent.getX();
                translateY = parent.getY();
                g.clipRect(parent.getX(), parent.getY(), parent.getWidth(), parent.getHeight());
                break;
            }
        }
        g.clipRect(translateX + this.getX(), translateY + this.getY(), this.getWidth(), this.getHeight());
        if (background) {
            this.paintBackgrounds(g);
        }
        g.translate(translateX, translateY);
        this.paintInternal(g);
        g.translate(-translateX, -translateY);
        Form parentForm = this.getComponentForm();
        if (parentForm != null && (glass = parentForm.getGlassPane()) != null) {
            glass.paint(g, parentForm.getBounds());
        }
        g.setClip(clipX, clipY, clipW, clipH);
    }

    private void drawPainters(Graphics g, Component par, Component c, Rectangle bounds) {
        Border b;
        if (par == null) {
            return;
        }
        if (par.getStyle().getBgTransparency() != -1) {
            this.drawPainters(g, par.getParent(), par, bounds);
        }
        int transX = par.getAbsoluteX() + par.getScrollX();
        int transY = par.getAbsoluteY() + par.getScrollY();
        g.translate(transX, transY);
        ((Container)par).paintIntersecting(g, c, bounds, false);
        if (par.isBorderPainted() && (b = par.getBorder()).isBackgroundPainter()) {
            g.translate(-par.getX(), -par.getY());
            b.paintBorderBackground(g, par);
            b.paint(g, par);
            g.translate(par.getX() - transX, par.getY() - transY);
            return;
        }
        Painter p = par.getStyle().getBgPainter();
        if (p != null) {
            p.paint(g, new Rectangle(0, 0, par.getWidth(), par.getHeight()));
        }
        g.translate(-transX, -transY);
    }

    protected Border getBorder() {
        Border b = this.getStyle().getBorder();
        if (this.hasFocus()) {
            if (b != null) {
                return b.getFocusedInstance();
            }
            return b;
        }
        return b;
    }

    protected void paintBackground(Graphics g) {
        Border b;
        if (this.isBorderPainted() && (b = this.getBorder()) != null && b.isBackgroundPainter()) {
            b.paintBorderBackground(g, this);
            return;
        }
        if (this.getStyle().getBgPainter() != null) {
            this.getStyle().getBgPainter().paint(g, new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight()));
        }
    }

    public void paint(Graphics g) {
    }

    protected boolean isScrollable() {
        return this.isScrollableX() || this.isScrollableY();
    }

    public boolean isScrollableX() {
        return false;
    }

    public boolean isScrollableY() {
        return false;
    }

    public int getScrollX() {
        return this.scrollX;
    }

    public int getScrollY() {
        return this.scrollY;
    }

    protected void setScrollX(int scrollX) {
        if (this.isScrollableX()) {
            this.scrollX = scrollX;
            this.repaint();
        }
    }

    protected void setScrollY(int scrollY) {
        if (this.isScrollableY()) {
            this.scrollY = scrollY;
            this.repaint();
        }
    }

    public int getBottomGap() {
        if (this.isScrollableX() && this.isScrollVisible()) {
            return UIManager.getInstance().getLookAndFeel().getHorizontalScrollHeight();
        }
        return 0;
    }

    public int getSideGap() {
        if (this.isScrollableY() && this.isScrollVisible()) {
            return UIManager.getInstance().getLookAndFeel().getVerticalScrollWidth();
        }
        return 0;
    }

    public boolean contains(int x, int y) {
        int absX = this.getAbsoluteX() + this.getScrollX();
        int absY = this.getAbsoluteY() + this.getScrollY();
        return x >= absX && x < absX + this.getWidth() && y >= absY && y < absY + this.getHeight();
    }

    protected Dimension calcPreferredSize() {
        Dimension d = new Dimension(0, 0);
        return d;
    }

    private Dimension preferredSize() {
        if (!this.sizeRequestedByUser && (this.shouldCalcPreferredSize || this.preferredSize == null)) {
            this.shouldCalcPreferredSize = false;
            this.preferredSize = this.calcPreferredSize();
        }
        return this.preferredSize;
    }

    protected Rectangle getBounds() {
        return this.bounds;
    }

    public boolean isFocusable() {
        return this.focusable && this.enabled && this.isVisible();
    }

    public void setFocusable(boolean focusable) {
        this.focusable = focusable;
        Form p = this.getComponentForm();
        if (p != null) {
            p.clearFocusVectors();
        }
    }

    protected void setShouldCalcPreferredSize(boolean shouldCalcPreferredSize) {
        if (shouldCalcPreferredSize != this.shouldCalcPreferredSize) {
            this.shouldCalcPreferredSize = shouldCalcPreferredSize;
            if (shouldCalcPreferredSize && this.getParent() != null) {
                this.shouldCalcPreferredSize = shouldCalcPreferredSize;
                this.getParent().setShouldCalcPreferredSize(shouldCalcPreferredSize);
            }
        }
    }

    public boolean isFocusPainted() {
        return this.focusPainted;
    }

    public void setFocusPainted(boolean focusPainted) {
        this.focusPainted = focusPainted;
    }

    public boolean handlesInput() {
        return this.handlesInput;
    }

    public void setHandlesInput(boolean handlesInput) {
        this.handlesInput = handlesInput;
    }

    public boolean hasFocus() {
        return this.focused;
    }

    public void setFocus(boolean focused) {
        this.focused = focused;
    }

    public Form getComponentForm() {
        Form retVal = null;
        Container parent = this.getParent();
        if (parent != null) {
            retVal = parent.getComponentForm();
        }
        return retVal;
    }

    void repaint(Component cmp) {
        if (this.isCellRenderer() || cmp.getWidth() <= 0 || cmp.getHeight() <= 0) {
            return;
        }
        Container parent = this.getParent();
        if (parent != null) {
            parent.repaint(cmp);
        }
    }

    public void repaint() {
        if (this.dirtyRegion != null) {
            this.setDirtyRegion(null);
        }
        this.repaint(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint(int x, int y, int w, int h) {
        Rectangle rect;
        Object object = this.dirtyRegionLock;
        synchronized (object) {
            if (this.dirtyRegion == null) {
                rect = new Rectangle(x, y, w, h);
            } else {
                rect = new Rectangle(this.dirtyRegion);
                Dimension size = rect.getSize();
                int x1 = Math.min(rect.getX(), x);
                int y1 = Math.min(rect.getY(), y);
                int x2 = Math.max(x + w, rect.getX() + size.getWidth());
                int y2 = Math.max(y + h, rect.getY() + size.getHeight());
                rect.setX(x1);
                rect.setY(y1);
                size.setWidth(x2 - x1);
                size.setHeight(y2 - y1);
                this.setDirtyRegion(rect);
            }
        }
        this.setDirtyRegion(rect);
        this.repaint(this);
    }

    protected void longKeyPress(int keyCode) {
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
    }

    public void keyRepeated(int keyCode) {
        int game = Display.getInstance().getGameAction(keyCode);
        if (game == 6 || game == 1 || game == 2 || game == 5) {
            this.keyPressed(keyCode);
            this.keyReleased(keyCode);
        }
    }

    private void setAnimationMotion(Motion motion) {
        this.animationMotion = motion;
    }

    private Motion getAnimationMotion() {
        return this.animationMotion;
    }

    public int getScrollAnimationSpeed() {
        return this.animationSpeed;
    }

    public void setScrollAnimationSpeed(int animationSpeed) {
        this.animationSpeed = animationSpeed;
    }

    public boolean isSmoothScrolling() {
        return this.smoothScrolling;
    }

    public void setSmoothScrolling(boolean smoothScrolling) {
        this.smoothScrolling = smoothScrolling;
        Form f = this.getComponentForm();
        if (f != null) {
            if (smoothScrolling && this.isScrollable()) {
                f.registerAnimated(this);
            } else {
                f.deregisterAnimated(this);
            }
        }
    }

    public void pointerHover(int[] x, int[] y) {
    }

    public void pointerDragged(int[] x, int[] y) {
        this.pointerDragged(x[0], y[0]);
    }

    public void pointerDragged(int x, int y) {
        if (this.isScrollable() && this.isSmoothScrolling()) {
            long currentTime;
            int axisValue = this.isScrollableY() ? y : x;
            if (!this.dragActivated) {
                this.dragActivated = true;
                this.beforeLastScrollY = axisValue;
                this.lastScrollY = axisValue;
                this.getComponentForm().setDraggedComponent(this);
            }
            if ((currentTime = System.currentTimeMillis()) != this.lastTime[(this.pLastDragged + this.lastTime.length + 1) % this.lastTime.length]) {
                this.lastTime[this.pLastDragged] = System.currentTimeMillis();
                this.lastDragged[this.pLastDragged] = axisValue;
                ++this.pLastDragged;
                this.pLastDragged %= this.lastTime.length;
            }
            this.beforeLastScrollY = this.lastScrollY;
            this.lastScrollY = axisValue;
            if (this.isScrollableY()) {
                int scroll = this.getScrollY() + (this.beforeLastScrollY - axisValue);
                if (scroll >= 0 && scroll < this.getPreferredH() - this.getHeight()) {
                    this.setScrollY(scroll);
                }
            } else {
                int scroll = this.getScrollX() + (this.beforeLastScrollY - axisValue);
                if (scroll >= 0 && scroll < this.getPreferredW() - this.getWidth()) {
                    this.setScrollX(scroll);
                }
            }
        } else {
            Container parent = this.getParent();
            if (!(parent instanceof Form)) {
                parent.pointerDragged(x, y);
            }
        }
    }

    private void initScrollMotion() {
        Motion m = Motion.createLinearMotion(this.initialScrollY, this.destScrollY, this.getScrollAnimationSpeed());
        this.setAnimationMotion(m);
        m.start();
    }

    public void pointerPressed(int[] x, int[] y) {
        this.pointerPressed(x[0], y[0]);
    }

    public void pointerPressed(int x, int y) {
        this.draggedMotion = null;
    }

    public void pointerReleased(int[] x, int[] y) {
        this.pointerReleased(x[0], y[0]);
    }

    public void pointerReleased(int x, int y) {
        if (this.dragActivated) {
            long currentTime = System.currentTimeMillis();
            if (!this.isScrollableY()) {
                y = x;
            }
            if (currentTime != this.lastTime[(this.pLastDragged + this.lastTime.length + 1) % this.lastTime.length]) {
                this.lastTime[this.pLastDragged] = System.currentTimeMillis();
                this.lastDragged[this.pLastDragged] = y;
                ++this.pLastDragged;
                this.pLastDragged %= this.lastTime.length;
            }
            float velocity = (float)(this.lastDragged[this.pLastDragged] - this.lastDragged[(this.pLastDragged + this.lastDragged.length + 1) % this.lastDragged.length]) / (float)(this.lastTime[this.pLastDragged] - this.lastTime[(this.pLastDragged + this.lastTime.length + 1) % this.lastTime.length]);
            this.draggedMotion = this.isScrollableY() ? Motion.createFrictionMotion(this.scrollY, velocity, 4.0E-4f) : Motion.createFrictionMotion(this.scrollX, velocity *= -1.0f, 4.0E-4f);
            this.draggedMotion.start();
            this.dragActivated = false;
        }
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        if (this.style != null) {
            this.style.removeStyleListener(this);
        }
        this.style = style;
        this.style.addStyleListener(this);
        if (this.style.getBgPainter() == null) {
            this.style.setBgPainter(new BGPainter());
        }
        this.setShouldCalcPreferredSize(true);
        this.checkAnimation();
    }

    public void requestFocus() {
        Form rootForm = this.getComponentForm();
        if (rootForm != null) {
            rootForm.requestFocus(this);
        }
    }

    public String toString() {
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1);
        return className + "[" + this.paramString() + "]";
    }

    protected String paramString() {
        return "x=" + this.getX() + " y=" + this.getY() + " width=" + this.getWidth() + " height=" + this.getHeight();
    }

    public void refreshTheme() {
        this.refreshTheme(this.getUIID());
    }

    protected void refreshTheme(String id) {
        if (this.style.isModified()) {
            this.style.merge(UIManager.getInstance().getComponentStyle(id));
        } else {
            this.setStyle(UIManager.getInstance().getComponentStyle(id));
        }
        this.checkAnimation();
        UIManager.getInstance().getLookAndFeel().bind(this);
    }

    boolean isDragActivated() {
        return this.dragActivated;
    }

    void checkAnimation() {
        Form parent;
        Image bgImage = this.getStyle().getBgImage();
        if (bgImage != null && bgImage.isAnimation() && (parent = this.getComponentForm()) != null) {
            parent.registerAnimated(this);
        }
    }

    public boolean animate() {
        Image bgImage = this.getStyle().getBgImage();
        boolean animateBackground = bgImage != null && bgImage.isAnimation() && ((Animation)((Object)bgImage)).animate();
        Motion m = this.getAnimationMotion();
        if (m != null && this.destScrollY != -1 && this.destScrollY != this.getScrollY()) {
            this.scrollY = m.getValue();
            if (this.destScrollY == this.scrollY) {
                this.destScrollY = -1;
            }
            return true;
        }
        if (this.draggedMotion != null && !this.draggedMotion.isFinished()) {
            int dragVal = this.draggedMotion.getValue();
            if (this.isScrollableY()) {
                if (dragVal >= 0 && dragVal <= this.getPreferredH() - this.getHeight()) {
                    this.scrollY = dragVal;
                    return true;
                }
            } else if (dragVal >= 0 && dragVal <= this.getPreferredW() - this.getWidth()) {
                this.scrollX = dragVal;
                return true;
            }
        }
        if (animateBackground && bgImage instanceof StaticAnimation) {
            Rectangle dirty = ((StaticAnimation)bgImage).getDirtyRegion();
            if (dirty != null) {
                dirty.setX(this.getAbsoluteX());
                dirty.setY(this.getAbsoluteY() + dirty.getY());
            }
            this.setDirtyRegion(dirty);
        }
        return animateBackground;
    }

    boolean isFixedPosition() {
        return this.fixedPosition;
    }

    void setFixedPosition(boolean fixedPosition) {
        this.fixedPosition = fixedPosition;
    }

    protected void scrollRectToVisible(Rectangle rect, Component coordinateSpace) {
        if (this.isScrollable()) {
            int scrollPosition = this.getScrollY();
            int w = this.getWidth() - this.getStyle().getPadding(1) - this.getStyle().getPadding(3);
            int h = this.getHeight() - this.getStyle().getPadding(0) - this.getStyle().getPadding(2);
            Rectangle view = new Rectangle(this.getScrollX(), this.getScrollY(), w, h);
            int relativeX = rect.getX();
            int relativeY = rect.getY();
            Container parent = null;
            if (coordinateSpace != null) {
                parent = coordinateSpace.getParent();
            }
            if (parent == this) {
                if (view.contains(rect)) {
                    return;
                }
            } else {
                while (parent != this) {
                    if (parent == null) {
                        relativeX = rect.getX();
                        relativeY = rect.getY();
                        break;
                    }
                    relativeX += parent.getX();
                    relativeY += parent.getY();
                    parent = parent.getParent();
                }
                if (view.contains(relativeX, relativeY, rect.getSize().getWidth(), rect.getSize().getHeight())) {
                    return;
                }
            }
            if (this.isScrollableX()) {
                if (this.getScrollX() > relativeX) {
                    this.setScrollX(relativeX);
                }
                int rightX = relativeX + rect.getSize().getWidth();
                if (this.getScrollX() + w < rightX) {
                    this.setScrollX(this.getScrollX() + (rightX - (this.getScrollX() + w)));
                } else if (this.getScrollX() > relativeX) {
                    this.setScrollX(relativeX);
                }
            }
            if (this.isScrollableY()) {
                if (this.getScrollY() > relativeY) {
                    scrollPosition = relativeY;
                }
                int bottomY = relativeY + rect.getSize().getHeight();
                if (this.getScrollY() + h < bottomY) {
                    scrollPosition = this.getScrollY() + (bottomY - (this.getScrollY() + h));
                } else if (this.getScrollY() > relativeY) {
                    scrollPosition = relativeY;
                }
                if (this.isSmoothScrolling()) {
                    this.initialScrollY = this.getScrollY();
                    this.destScrollY = scrollPosition;
                    this.initScrollMotion();
                } else {
                    this.setScrollY(scrollPosition);
                }
            }
            this.repaint();
        }
    }

    public void setBorderPainted(boolean b) {
        if (!b) {
            this.getStyle().setBorder(null);
        } else {
            this.getStyle().setBorder(Border.getDefaultBorder());
        }
    }

    public boolean isBorderPainted() {
        return this.getStyle().getBorder() != null;
    }

    protected void paintBorder(Graphics g) {
        Border b = this.getBorder();
        if (b != null) {
            if (this.isFocusPainted() && this.hasFocus()) {
                g.setColor(this.getStyle().getFgSelectionColor());
            } else {
                g.setColor(this.getStyle().getFgColor());
            }
            b.paint(g, this);
        }
    }

    public void setCellRenderer(boolean cellRenderer) {
        this.cellRenderer = cellRenderer;
    }

    boolean isCellRenderer() {
        return this.cellRenderer;
    }

    public boolean isScrollVisible() {
        return this.isScrollVisible;
    }

    public void setIsScrollVisible(boolean isScrollVisible) {
        this.isScrollVisible = isScrollVisible;
    }

    void initComponentImpl() {
        if (!this.initialized) {
            this.initialized = true;
            if (this.isSmoothScrolling() && this.isScrollable()) {
                this.getComponentForm().registerAnimated(this);
            }
            UIManager.getInstance().getLookAndFeel().bind(this);
            this.checkAnimation();
            this.initComponent();
        }
    }

    void deinitializeImpl() {
        if (this.isInitialized()) {
            this.setInitialized(false);
            this.setDirtyRegion(null);
            this.deinitialize();
        }
    }

    protected void deinitialize() {
    }

    protected void initComponent() {
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public void styleChanged(String propertyName, Style source) {
        if (!this.shouldCalcPreferredSize && propertyName.equals("font") || propertyName.equals("margin") || propertyName.equals("padding")) {
            this.setShouldCalcPreferredSize(true);
            Container parent = this.getParent();
            if (parent != null) {
                parent.revalidate();
            }
        }
    }

    public Component getNextFocusDown() {
        return this.nextFocusDown;
    }

    public void setNextFocusDown(Component nextFocusDown) {
        this.nextFocusDown = nextFocusDown;
    }

    public Component getNextFocusUp() {
        return this.nextFocusUp;
    }

    public void setNextFocusUp(Component nextFocusUp) {
        this.nextFocusUp = nextFocusUp;
    }

    public Component getNextFocusLeft() {
        return this.nextFocusLeft;
    }

    public void setNextFocusLeft(Component nextFocusLeft) {
        this.nextFocusLeft = nextFocusLeft;
    }

    public Component getNextFocusRight() {
        return this.nextFocusRight;
    }

    public void setNextFocusRight(Component nextFocusRight) {
        this.nextFocusRight = nextFocusRight;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    void onEditComplete(String text) {
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        Form f = this.getComponentForm();
        if (f != null) {
            f.clearFocusVectors();
            this.repaint();
        }
    }

    class BGPainter
    implements Painter {
        private Form parent;
        private Form previousTint;
        private boolean ignorCoordinates;
        private Painter painter;

        public BGPainter() {
        }

        public BGPainter(Form parent, Painter p) {
            this.painter = p;
            this.parent = parent;
        }

        public void setIgnorCoordinates(boolean ignorCoordinates) {
            this.ignorCoordinates = ignorCoordinates;
        }

        public void setPreviousForm(Form previous) {
            this.previousTint = previous;
        }

        public void paint(Graphics g, Rectangle rect) {
            if (this.painter != null) {
                if (this.previousTint != null) {
                    this.previousTint.paint(g);
                }
                Dimension d = rect.getSize();
                int width = d.getWidth();
                int height = d.getHeight();
                int x = rect.getX();
                int y = rect.getY();
                if (this.ignorCoordinates) {
                    x = 0;
                    y = 0;
                    width = this.parent.getWidth();
                    height = this.parent.getHeight();
                    int transY = g.getTranslateY();
                    g.translate(0, -transY);
                    this.painter.paint(g, new Rectangle(x, y, width, height));
                    g.translate(0, transY);
                } else {
                    this.painter.paint(g, new Rectangle(x, y, width, height));
                }
            } else {
                Style s = Component.this.getStyle();
                int x = rect.getX();
                int y = rect.getY();
                int width = rect.getSize().getWidth();
                int height = rect.getSize().getHeight();
                if (width <= 0 || height <= 0) {
                    return;
                }
                Image bgImage = s.getBgImage();
                if (bgImage == null) {
                    if (Component.this.hasFocus() && Component.this.isFocusPainted()) {
                        g.setColor(s.getBgSelectionColor());
                        g.fillRect(x, y, width, height, s.getBgTransparency());
                    } else {
                        g.setColor(s.getBgColor());
                        g.fillRect(x, y, width, height, s.getBgTransparency());
                    }
                } else {
                    if (Component.this.getStyle().isScaleImage()) {
                        if (bgImage.getWidth() != width || bgImage.getHeight() != height) {
                            bgImage = bgImage.scaled(width, height);
                            s.setBgImage(bgImage, true);
                        }
                    } else {
                        int iW = bgImage.getWidth();
                        int iH = bgImage.getHeight();
                        for (int xPos = 0; xPos <= width; xPos += iW) {
                            for (int yPos = 0; yPos <= height; yPos += iH) {
                                g.drawImage(s.getBgImage(), x + xPos, y + yPos);
                            }
                        }
                        return;
                    }
                    g.drawImage(s.getBgImage(), x, y);
                }
            }
        }
    }
}

